/*
 * Decompiled with CFR 0.152.
 */
package CP.Game;

import CP.Blocks.Blocks;
import CP.Canvas.Canvas;
import CP.DefaultBlocks.DefaultBlocks;
import CP.DefaultMobs.DefaultMobs;
import CP.DefaultWindows.DefaultWindows;
import CP.Drop.Drop;
import CP.GUI.GUI;
import CP.Inventory.Inventory;
import CP.Item.Item;
import CP.Item.Item_Item;
import CP.Keyboard.Keyboard;
import CP.Log.Log;
import CP.Map.Map;
import CP.Mobs.Mobs;
import CP.Player.Player;
import CP.String.String;
import CP.System.System;
import CP.Text.Text;
import javax.microedition.lcdui.Image;

public final class Game {
    static int curx;
    static int cury;
    static boolean editmode;
    static Image editcursor;

    static void DrawDebugInfo() {
        Canvas.SetColor(255, 255, 255);
        java.lang.String string = String.IntToString(Canvas.GetFps());
        int n = 0;
        Text.Draw(string, 0, n);
        string = String.RealToString(Player.GetX());
        Text.Draw(string, 0, n += Text.Height(string));
        string = String.RealToString(Player.GetY());
        Text.Draw(string, 0, n += Text.Height(string));
    }

    static void DrawGame() {
        int n = (int)Math.floor(Player.GetX() * 16.0) - (Canvas.GetWidth() >> 1);
        int n2 = (int)Math.floor(Player.GetY() * 16.0) - (Canvas.GetHeight() >> 1);
        int[] nArray = new int[1];
        n = Map.BlockCamera(n, n2, nArray);
        n2 = nArray[0];
        Canvas.SetColor(0, 0, 127);
        Canvas.FillRect(0, 0, Canvas.GetWidth(), Canvas.GetHeight());
        Map.DrawMap(n, n2);
        Mobs.Draw(n, n2);
        Drop.Draw(n, n2);
        if (editmode) {
            CP.Image.Image.Draw(editcursor, curx * 16 - n, cury * 16 - n2);
        }
        Inventory.DrawFastInventory(Player.GetInv());
        GUI.Draw();
        Game.DrawDebugInfo();
    }

    static void Std_KeyHandler() {
        if (Keyboard.KeyPressed(-1) || Keyboard.KeyPressed(50)) {
            Player.GoUp();
        }
        if (Keyboard.KeyPressed(-2) || Keyboard.KeyPressed(56)) {
            Player.GoDown();
        }
        if (Keyboard.KeyPressed(-3) || Keyboard.KeyPressed(52)) {
            Player.GoLeft();
        }
        if (Keyboard.KeyPressed(-4) || Keyboard.KeyPressed(54)) {
            Player.GoRight();
        }
        if (Keyboard.KeyClicked(-5) || Keyboard.KeyClicked(53)) {
            Mobs.Create("PLAYER", Player.GetX(), Player.GetY());
        }
        if (Keyboard.KeyClicked(49)) {
            DefaultWindows.OpenInventory(Player.GetInv());
        }
        if (Keyboard.KeyClicked(51)) {
            Item_Item[] item_ItemArray = Player.GetInv().items;
            item_ItemArray[Inventory.invprt] = Item.Use(Player.GetInv().items[Inventory.invprt], (int)Math.floor(Player.GetX()), (int)Math.floor(Player.GetY()));
        }
        if (Keyboard.KeyClicked(57)) {
            System.Exit(0);
        }
        if (Keyboard.KeyClicked(48)) {
            editmode = true;
            curx = (int)Math.floor(Player.GetX());
            cury = (int)Math.floor(Player.GetY());
        }
        if (Keyboard.KeyClicked(35)) {
            Inventory.ShiftFastInvCursor(Player.GetInv(), 1);
        }
        if (Keyboard.KeyClicked(42)) {
            Inventory.ShiftFastInvCursor(Player.GetInv(), -1);
        }
    }

    static void Edit_KeyHandler() {
        if (Keyboard.KeyClicked(-1) || Keyboard.KeyClicked(50)) {
            --cury;
        }
        if (Keyboard.KeyClicked(-2) || Keyboard.KeyClicked(56)) {
            ++cury;
        }
        if (Keyboard.KeyClicked(-3) || Keyboard.KeyClicked(52)) {
            --curx;
        }
        if (Keyboard.KeyClicked(-4) || Keyboard.KeyClicked(54)) {
            ++curx;
        }
        if (Keyboard.KeyClicked(-5) || Keyboard.KeyClicked(53)) {
            Blocks.InfoList[Map.Get(curx, cury)].Destroy(curx, cury);
        }
        if (Keyboard.KeyClicked(51)) {
            Item_Item[] item_ItemArray = Player.GetInv().items;
            item_ItemArray[Inventory.invprt] = Item.Use(Player.GetInv().items[Inventory.invprt], curx, cury);
        }
        if (Keyboard.KeyClicked(57)) {
            System.Exit(0);
        }
        if (Keyboard.KeyClicked(48)) {
            editmode = false;
        }
        if (Keyboard.KeyClicked(35)) {
            Inventory.ShiftFastInvCursor(Player.GetInv(), 1);
        }
        if (Keyboard.KeyClicked(42)) {
            Inventory.ShiftFastInvCursor(Player.GetInv(), -1);
        }
    }

    static void KeyHandler() {
        if (!GUI.KeyHandled()) {
            if (editmode) {
                Game.Edit_KeyHandler();
            } else {
                Game.Std_KeyHandler();
            }
        }
        Keyboard.Update();
    }

    public static void Main() {
        Log.PrintLn("Start Main");
        editcursor = CP.Image.Image.Resize(CP.Image.Image.Load("/cursor.png"), 16, 16);
        double d = 0.0;
        double d2 = (1024.0 - (double)Canvas.GetHeight() / 2.0) / 16.0;
        DefaultBlocks.Init();
        DefaultMobs.Init();
        Player.SetController(Mobs.CreateRET("PLAYER", d, d2));
        Log.PrintLn("Main Loop");
        while (true) {
            Game.KeyHandler();
            Player.Do();
            Mobs.DoAi();
            Mobs.DoPhysics();
            Drop.DoPhysics();
            Game.DrawGame();
            Canvas.Repaint();
            Canvas.Delay(1);
        }
    }
}

